﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Xml.Serialization;
using Htz.eVisitor.WebApi.Test.Properties;
using RestSharp;

namespace Htz.eVisitor.WebApi.Test
{
    public static class Utility
    {
        public static string RestUrl
        {
            get { return String.Format("{0}/Rest/Htz/", Settings.Default.ServiceUrl); }
        }

        public static string AuthenticationUrl
        {
            get { return String.Format("{0}/Resources/AspNetFormsAuth/Authentication/", Settings.Default.ServiceUrl); }
        }

        public static string ImpersonationUrl
        {
            get { return String.Format("{0}/Resources/AspNetFormsAuthImpersonation/Impersonation/", Settings.Default.ServiceUrl); }
        }

        public static IEnumerable<RestResponseCookie> Login()
        {
            var restRequest = new RestRequest()
            {
                Method = Method.POST,
                Resource = "Login",
                RequestFormat = DataFormat.Json,
            };

            restRequest.AddBody(new { UserName = Settings.Default.Username, Password = Settings.Default.Password, PersistCookie = false });

            var restClient = new RestClient(AuthenticationUrl);
            var response = restClient.Execute(restRequest);

            if (response.StatusCode != HttpStatusCode.OK)
                throw new Exception(response.Content);
            if (response.StatusCode == HttpStatusCode.OK && response.Content == "false")
                throw new Exception("Invalid username or password.");

            var cookies = response.Cookies.Where(x => !string.IsNullOrEmpty(x.Value)).ToList();

            if (cookies.Any())
                return cookies;

            Console.WriteLine("ERROR: {0}", response.StatusDescription);
            Console.WriteLine("Content: {0}", response.Content);
            return null;
        }

        public static void Logout(IEnumerable<RestResponseCookie> cookies)
        {
            var restRequest = new RestRequest()
            {
                Method = Method.POST,
                Resource = "Logout",
                RequestFormat = DataFormat.Json,
            };
            restRequest.AddCookies(cookies);
            var restClient = new RestClient(AuthenticationUrl);
            restClient.Execute(restRequest);
        }


        public static string SerializeToXml(object obj)
        {
            XmlSerializer serializer = new XmlSerializer(obj.GetType());
            StringBuilder xml = new StringBuilder();
            TextWriter writer = new StringWriter(xml);
            serializer.Serialize(writer, obj);
            writer.Flush();
            writer.Close();
            xml.Replace("<?xml version=\"1.0\" encoding=\"utf-16\"?>", "<?xml version=\"1.0\"?>");
            return xml.ToString();
        }

        public static T DeserializeFromXml<T>(string xml)
        {
            if (String.IsNullOrEmpty(xml))
                return default(T);

            XmlSerializer serializer = new XmlSerializer(typeof(T));
            TextReader reader = new StringReader(xml);
            return (T)serializer.Deserialize(reader);
        }

        public static void AddCookies(this RestRequest request, IEnumerable<RestResponseCookie> cookies)
        {
            foreach (var cookie in cookies)
                request.AddCookie(cookie.Name, cookie.Value);
        }

        public static IRestResponse ExecuteAction(string action, object data, IEnumerable<RestResponseCookie> cookies, Method method = Method.GET)
        {
            var restRequest = new RestRequest
            {
                Method = method,
                Resource = action,
                RequestFormat = DataFormat.Json,
            };
            restRequest.AddCookies(cookies);
            if (data != null)
                restRequest.AddBody(data);

            var restClient = new RestClient(RestUrl);
            return restClient.Execute(restRequest);
        }

    }
}