﻿using System;
using System.IO;
using System.Net;
using System.Text;
using Htz.eVisitor.WebApi.Test.Properties;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using RestSharp;

namespace Htz.eVisitor.WebApi.Test
{
    [TestClass]
    public class CheckInCheckOutOfTourists
    {
        [TestMethod]
        public void TouristCheckIn()
        {
            string xml;
            using (var stream = typeof(CheckInCheckOutOfTourists).Assembly.GetManifestResourceStream(@"Htz.eVisitor.WebApi.Test.TestData.TouristCheckIn.xml"))
            using(var reader = new StreamReader(stream))
            {
                xml = reader.ReadToEnd();
            }

            var cookies = Utility.Login();
            Assert.IsNotNull(cookies);

            var restRequest = new RestRequest
            {
                Method = Method.POST,
                Resource = "ImportTourists/",
                RequestFormat = DataFormat.Json,
            };
            restRequest.AddCookies(cookies);
            restRequest.AddBody(new { Xml = xml, Register = true });

            var restClient = new RestClient(Utility.RestUrl);
            var response = restClient.Execute(restRequest);

            Utility.Logout(cookies);

            Assert.AreEqual(string.Empty, response.Content);
            Assert.AreEqual(HttpStatusCode.OK, response.StatusCode);
        }

        [TestMethod]
        public void TouristCheckOut()
        {
            string xml;
            using (var stream = typeof(CheckInCheckOutOfTourists).Assembly.GetManifestResourceStream(@"Htz.eVisitor.WebApi.Test.TestData.TouristCheckOut.xml"))
            using (var reader = new StreamReader(stream))
            {
                xml = reader.ReadToEnd();
            }

            var cookies = Utility.Login();
            Assert.IsNotNull(cookies);

            var restRequest = new RestRequest
            {
                Method = Method.POST,
                Resource = "ImportTouristCheckOut",
                RequestFormat = DataFormat.Json,
            };
            restRequest.AddCookies(cookies);
            restRequest.AddBody(new { Xml = xml });

            var restClient = new RestClient(Utility.RestUrl);
            var response = restClient.Execute(restRequest);

            Utility.Logout(cookies);
            Assert.AreEqual(string.Empty, response.Content);
            Assert.AreEqual(HttpStatusCode.OK, response.StatusCode);
        }

        [TestMethod]
        public void EditOfExistingCheckIn()
        {
            string xml;
            using (var stream = typeof(CheckInCheckOutOfTourists).Assembly.GetManifestResourceStream(@"Htz.eVisitor.WebApi.Test.TestData.EditOfExistingCheckIn.xml"))
            using (var reader = new StreamReader(stream))
            {
                xml = reader.ReadToEnd();
            }

            var cookies = Utility.Login();
            Assert.IsNotNull(cookies);

            var restRequest = new RestRequest
            {
                Method = Method.POST,
                Resource = "ImportTourists/",
                RequestFormat = DataFormat.Json,
            };
            restRequest.AddCookies(cookies);
            restRequest.AddBody(new { Xml = xml, Register = true });

            var restClient = new RestClient(Utility.RestUrl);
            var response = restClient.Execute(restRequest);

            Utility.Logout(cookies);

            Assert.AreEqual(string.Empty, response.Content);
            Assert.AreEqual(HttpStatusCode.OK, response.StatusCode);
        }
        [TestMethod]
        public void TestRead()
        {
            var cookies = Utility.Login();
            Assert.IsNotNull(cookies);

            var restRequest = new RestRequest
            {
                Method = Method.GET,
                Resource = "Gender/",
                RequestFormat = DataFormat.Json,
            };
            restRequest.AddCookies(cookies);

            var restClient = new RestClient(Utility.RestUrl);
            var response = restClient.Execute(restRequest);

            Utility.Logout(cookies);
            Assert.AreEqual(HttpStatusCode.OK, response.StatusCode);
            Console.WriteLine(response.Content);
        }
    }
}